package net.ouska.networking;

import net.ouska.networking.gui.Animation;

public class Communication {

	public static IP dnsLookup(Sys system, Host host, String targetHostName) {
		IP ip = null;
		if (!IP.isValidIP(targetHostName)) {
			system.out("Looking up hostname " + targetHostName);
			if (host.getDns() == null) {
				throw new RuntimeException("DNS server missing!");
			}
			Message dnsReq = new Message(host.getDns());
			Host targetHost = Communication.sendOverInternet(host, dnsReq);
			Communication.sendOverInternet(targetHost, new Message(dnsReq.getSrc()));

			if (targetHost.getDnsConfiguration() == null) {
				throw new RuntimeException("DNS server not installed at " + host.getDns() + "!");
			}

			ip = targetHost.getDnsConfiguration().lookup(targetHostName);
			if (ip == null) {
				throw new RuntimeException("Unknown hostname " + targetHostName + "!");
			}
		} else {
			ip = new IP(targetHostName);
		}
		return ip;
	}
	
	public static Host sendOverInternet(Host host, Message message) {
		Sys system = host.getSystem();
		system.debug("-----------------------------------");
		while (true) {
			for (Eth eth : host.getEths().values()) {
				if (eth.isActive() && eth.getIp().equals(message.getDest())) {
					// jsem v cili
					if (message.getSrc() == null) {
						message.setSrc(eth.getIp());	
					}
					system.debug(host.getName() + ": Packet reached its destination.");
					system.debug("-----------------------------------");
					return eth.getHost(); 
				}
			}
			host = sendOverEthernet(host, message);
			system.debug("-----------------------------------");
		}
	}

	public static Host sendOverEthernet(Host host, Message message) {
		Sys system = host.getSystem();
		system.debug(host.getName() + ": IP packet to " + message.getDest());
		IP ip = null;
		Eth usedEth = null;
		for (Eth eth : host.getEths().values()) {
			if (eth.isActive() && eth.isInMyNetwork(message.getDest())) {
				usedEth = eth;
				ip = message.getDest();
				if (message.getSrc() == null) {
					message.setSrc(eth.getIp());	
				}
				break;
			}
		}
		
		if (ip == null) {
			system.debug(host.getName() + ": IP " + message.getDest() + " is not in my networks. Looking for default gateway...");
			if (host.getGateway() == null) {
				system.debug(host.getName() + ": No default gateway defined");
				throw new RuntimeException("No gateway");
			}
			system.debug(host.getName() + ": My default gateway is " + host.getGateway());
			for (Eth eth : host.getEths().values()) {
				if (eth.isActive() && eth.isInMyNetwork(host.getGateway())) {
					usedEth = eth;
					ip = host.getGateway();
					if (message.getSrc() == null) {
						message.setSrc(eth.getIp());	
					}
					system.debug(host.getName() + ": Sending IP packet to " + message.getDest() + " through my gateway " + host.getGateway());
					break;
				}
			}
		}
		
		if (ip == null) {
			system.debug(host.getName() + ": My default gateway is not in my network.");
			throw new RuntimeException("No route to host " + message.getDest());
		}
		
		system.debug(host.getName() + ": Who has " + ip + " ?");		
		Eth targetEth = host.getArp().get(ip);
		if (targetEth == null) {
			targetEth = whoIsIP(usedEth.getNetwork(), ip);	
		}
		
		if (targetEth == null) {
			throw new RuntimeException("Host unreachable " + message.getDest());
		}
		system.debug(host.getName() + 
			": Sending ethernet frame: " +
			"" + usedEth.getMac() + " ("+usedEth.getHost().getName()+":"+usedEth.getName()+") " + 
			"--> " + targetEth.getMac() + " ("+targetEth.getHost().getName()+":"+targetEth.getName()+")");
		
		host.getArp().put(ip, targetEth);
		
		Animation.add(usedEth, targetEth);
		
		return targetEth.getHost();
	}

	public static Eth whoIsIP(Network network, IP ip) {
		Eth result = null;
		if (network != null && ip != null) {
			for (Eth eth : network.getEths().values()) {
				if (eth.isActive() && ip.equals(eth.getIp())) {
					result = eth;
					break;
				}
			}
		}
		return result;
	}

}
