package net.ouska.networking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultCaret;

import net.ouska.networking.command.HostCommand;
import net.ouska.networking.command.HostCommandArp;
import net.ouska.networking.command.HostCommandDhcp;
import net.ouska.networking.command.HostCommandDisconnect;
import net.ouska.networking.command.HostCommandDns;
import net.ouska.networking.command.HostCommandEmail;
import net.ouska.networking.command.HostCommandExit;
import net.ouska.networking.command.HostCommandHttp;
import net.ouska.networking.command.HostCommandInstall;
import net.ouska.networking.command.HostCommandIpconfig;
import net.ouska.networking.command.HostCommandPing;
import net.ouska.networking.command.HostCommandRestart;
import net.ouska.networking.command.HostCommandUninstall;
import net.ouska.networking.command.SystemCommand;
import net.ouska.networking.command.SystemCommandAttach;
import net.ouska.networking.command.SystemCommandConnect;
import net.ouska.networking.command.SystemCommandCreate;
import net.ouska.networking.command.SystemCommandDebug;
import net.ouska.networking.command.SystemCommandDelete;
import net.ouska.networking.command.SystemCommandDemo;
import net.ouska.networking.command.SystemCommandEnable;
import net.ouska.networking.command.SystemCommandExit;
import net.ouska.networking.command.SystemCommandHosts;
import net.ouska.networking.command.SystemCommandLoad;
import net.ouska.networking.command.SystemCommandNetworks;
import net.ouska.networking.command.SystemCommandRestart;
import net.ouska.networking.command.SystemCommandSave;
import net.ouska.networking.command.SystemCommandVisual;

public class Console extends JFrame implements KeyListener {

	public Map<String, SystemCommand> commands = new HashMap<String, SystemCommand>();
	public Map<String, HostCommand> hostCommands = new HashMap<String, HostCommand>();

	JTextArea area = new JTextArea();
	public JTextField txt = new JTextField();
	JLabel lblRoot = new JLabel();
	
	List<String> history = new ArrayList<String>();
	int historyPosition = 0;
	Sys system;
	public Sys template;
	
	public Console() throws HeadlessException {
		super("Network Administration");
		setSize(800, 500);
		setLocationRelativeTo(null);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setLayout(new BorderLayout());

		JScrollPane scrollPane = new JScrollPane(area);
		scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		
		getContentPane().add(scrollPane, BorderLayout.CENTER);
		
		JPanel bottom = new JPanel(new BorderLayout());
		bottom.add(lblRoot, BorderLayout.WEST);
		bottom.add(txt, BorderLayout.CENTER);
		
		getContentPane().add(scrollPane, BorderLayout.CENTER);
		getContentPane().add(bottom, BorderLayout.SOUTH);
		
		Font font = new Font("Consolas", Font.PLAIN, 14);
		area.setEditable(false);
		//txtRoot.setEnabled(false);
		area.setFont(new Font("Consolas", Font.PLAIN, 14));
		area.setForeground(Color.green);
		area.setBackground(Color.BLACK);
		area.setFocusable(false);
		area.setCaretColor(Color.GREEN);
	    DefaultCaret caret = (DefaultCaret)area.getCaret();
	    caret.setUpdatePolicy(DefaultCaret.OUT_BOTTOM);
	    
	    
		
		txt.setFont(font);
		txt.setForeground(Color.green);
		txt.setBackground(Color.BLACK);
		txt.setCaretColor(Color.GREEN);
		txt.addKeyListener(this);
		
		lblRoot.setFont(font);
		lblRoot.setForeground(Color.green);
		lblRoot.setBackground(Color.BLACK);
		lblRoot.setFocusable(false);
		lblRoot.setOpaque(true);
		
		txt.setBorder(new LineBorder(Color.BLACK, 8));
		lblRoot.setBorder(new LineBorder(Color.BLACK, 1));
		area.setBorder(new LineBorder(Color.BLACK, 8));
		bottom.setBorder(new LineBorder(Color.BLACK, 1));
	}
	
	public void initCommands() {
		addCommand(new SystemCommandHosts(system, template));
		addCommand(new SystemCommandRestart(system, template));
		addCommand(new SystemCommandDebug(system, template));
		addCommand(new SystemCommandEnable(system, template));
		addCommand(new SystemCommandConnect(system, template));
		addCommand(new SystemCommandExit(system, template));
		addCommand(new SystemCommandCreate(system, template));
		addCommand(new SystemCommandDelete(system, template));
		addCommand(new SystemCommandAttach(system, template));
		addCommand(new SystemCommandNetworks(system, template));
		addCommand(new SystemCommandSave(system, template));
		addCommand(new SystemCommandLoad(system, template));
		addCommand(new SystemCommandDemo(system, template));
		addCommand(new SystemCommandVisual(system, template));
	}
	
	public void initHostCommands(Host activeHost) {
		addCommand(new HostCommandRestart(system, template, activeHost));
		addCommand(new HostCommandDisconnect(system, template, activeHost));
		addCommand(new HostCommandIpconfig(system, template, activeHost));
		addCommand(new HostCommandPing(system, template, activeHost));
		addCommand(new HostCommandArp(system, template, activeHost));
		addCommand(new HostCommandUninstall(system, template, activeHost));
		addCommand(new HostCommandInstall(system, template, activeHost));
		addCommand(new HostCommandExit(system, template, activeHost));
		addCommand(new HostCommandDhcp(system, template, activeHost));
		addCommand(new HostCommandDns(system, template, activeHost));
		addCommand(new HostCommandHttp(system, template, activeHost));
		addCommand(new HostCommandEmail(system, template, activeHost));
	}
	
	public void addCommand(SystemCommand command) {
		commands.put(command.getName(), command);
	}

	public void addCommand(HostCommand command) {
		hostCommands.put(command.getName(), command);
	}

	@Override
	public void keyTyped(KeyEvent e) {}

	@Override
	public void keyReleased(KeyEvent e) {}
	
	@Override
	public void keyPressed(KeyEvent e) {
		if (e.getKeyCode() == KeyEvent.VK_ENTER) {
			String line = txt.getText().trim();
			if (!line.isEmpty()) {
				if (historyPosition < history.size() && history.get(historyPosition).equals(line)) {
					history.remove(historyPosition);
				}
				history.add(txt.getText());
				historyPosition = history.size();
				txt.setText(null);
			}
			system.onCommand(line);
			
	    } else if (e.getKeyCode() == KeyEvent.VK_UP) {
			historyPosition --;
			if (historyPosition < 0) {
				historyPosition = 0;
			} else {
				String text = history.get(historyPosition);
				txt.setText(text);
			}
	    } else if (e.getKeyCode() == KeyEvent.VK_DOWN) {
			historyPosition ++;
			if (historyPosition >= history.size()) {
				historyPosition = history.size();
				txt.setText(null);
			} else {
				txt.setText(history.get(historyPosition));
			}
	    } else if (e.getKeyCode() == KeyEvent.VK_CONTROL) {
			String completedLine = system.hint(txt.getText());
			if (completedLine != null) {
				txt.setText(completedLine);
			} 
	    }
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		Console console = new Console();
		console.setVisible(true);
		Sys system = new Sys(console, false);
		Sys template = new Sys(console, true);
		console.system = system;
		console.template = template;
		console.template.okno.setTitle("Mission goals");
		console.initCommands();
	}
	
	public void out(String value) {
		if (!area.getText().isEmpty()) {
			area.append("\n");	
		}
		area.append(value);
		area.setCaretPosition(area.getDocument().getLength());		
	}
	
	public void root(String value) {
		lblRoot.setText(value);
		lblRoot.setBackground(Color.BLACK);
		//txtRoot.setSize(new Dimension(value.length() * 20, 1));
	}

}
