package net.ouska.networking;

import java.util.HashMap;
import java.util.Map;

public class Dhcp {

	private Map<MAC, IP> table = new HashMap<MAC, IP>();
	private final IP poolStart;
	private final IP mask;
	private final IP gateway;
	private final IP dns;
	private int counter = 0;
	private final Host host;
	
	public Dhcp(Host host, IP poolStart, IP mask, IP gateway, IP dns) {
		super();
		this.host = host;
		this.poolStart = poolStart;
		this.mask = mask;
		this.gateway = gateway;
		this.dns = dns;
	}
	
	public DhcpAssignment assign(MAC mac) {
		IP ip = table.get(mac);
		if (ip == null) {
			ip = new IP(poolStart.getA(), poolStart.getB(), poolStart.getC(), poolStart.getD() + counter);
			counter++;
			table.put(mac, ip);
		}
		host.getSystem().out("DHCP server assigned IP " + mac + " -> " + ip);
		return new DhcpAssignment(ip, mask, gateway, dns);
	}

	public Map<MAC, IP> getTable() {
		return table;
	}

	public void setTable(Map<MAC, IP> table) {
		this.table = table;
	}

	public int getCounter() {
		return counter;
	}

	public void setCounter(int counter) {
		this.counter = counter;
	}

	public IP getPoolStart() {
		return poolStart;
	}

	public IP getMask() {
		return mask;
	}

	public IP getGateway() {
		return gateway;
	}

	public IP getDns() {
		return dns;
	}

	public Host getHost() {
		return host;
	}

	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("DHCP server configuration:");
		b.append("\n\tFirst IP " + poolStart);
		b.append("\n\tMask " + mask);
		if (gateway != null) {
			b.append("\n\tGateway " + gateway);	
		}
		if (dns != null) {
			b.append("\n\tDNS " + dns);	
		}
		b.append("\n\tAssigned IP addresses:");
		for (MAC mac : table.keySet()) {
			IP ip = table.get(mac);
			b.append("\n\t\t" + mac + " -> " + ip);
		} 
		return b.toString();
	}	
}
