package net.ouska.networking;

import java.util.HashMap;
import java.util.Map;

public class Dns {

	private final Host host;
	private Map<String, IP> table = new HashMap<String, IP>();
	
	public Dns(Host host) {
		super();
		this.host = host;
	}
	
	public IP lookup(String name) {
		return table.get(name);
	}

	public Host getHost() {
		return host;
	}
	
	public Map<String, IP> getTable() {
		return table;
	}

	public void setTable(Map<String, IP> table) {
		this.table = table;
	}

	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("DNS server configuration:");
		for (String name : table.keySet()) {
			IP ip = table.get(name);
			b.append("\n\t\t" + name + " -> " + ip);
		} 
		return b.toString();
	}	
}
