package net.ouska.networking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Email {

	private Map<String, List<String>> messages = new HashMap<String, List<String>>();
	private final Host host;
	
	public Email(Host host) {
		super();
		this.host = host;
	}

	public void addMessage(String recipient, String content) {
		List<String> list =  messages.get(recipient);
		if (list == null) {
			list = new ArrayList<String>();
			messages.put(recipient, list);
		}
		list.add(content);
	}

	public Host getHost() {
		return host;
	}

	
	public Map<String, List<String>> getMessages() {
		return messages;
	}

	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("Email server configuration:");
		for (String recipient : messages.keySet()) {
			b.append("\n\t\t" + recipient);
			for (String content : messages.get(recipient)) {
				b.append("\n\t\t\t" + content);	
			}
		} 
		return b.toString();
	}	
}
