package net.ouska.networking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Host implements Comparable<Host> {

	private final String name;
	private Map<String, Eth> eths = new HashMap<String, Eth>();
	private IP gateway;
	private IP dns;
	private Sys system;
	public Map<IP, Eth> arp = new HashMap<IP, Eth>();
	public Map<Network, Dhcp> dhcp = new HashMap<Network, Dhcp>();
	private Dns dnsConfiguration;
	private Email email;
	public Http http;
	public int x = -1;
	public int y = -1;
	//private Dhcp dhcp;

	public Host(Sys system, String name) {
		super();
		this.name = name;
		this.system = system;
	}

	public void restart() {
		for (Eth eth : eths.values()) {
			eth.reload();
		}
		arp.clear();
	}
	

	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("Host ");
		b.append(name);
		for (Eth eth : getSortedEths()) {
			b.append("\n\t");
			b.append(eth.toString());
		}
		if (dns != null) {
			b.append("\n\tDNS ");
			b.append(dns);
		}
		if (gateway != null) {
			b.append("\n\tGateway ");
			b.append(gateway);
		}
		if (dhcp != null) {
			for (Network network : dhcp.keySet()) {
				Dhcp d = dhcp.get(network);
				b.append("\n\n\t"+network.getName()+"\t");
				b.append(d);
			}
		}
		if (dnsConfiguration != null) {
			b.append("\n\n\t");
			b.append(dnsConfiguration);
		}
		if (http != null) {
			b.append("\n\n\t");
			b.append(http);
		}
		if (email != null) {
			b.append("\n\n\t");
			b.append(email);
		}
		
		return b.toString();
	}

	public String getName() {
		return name;
	}

	public Eth getEth(String name) {
		return eths.get(name);
	}

	public void addEth(String name, MAC mac) {
		addEth(new Eth(this, name, mac));
	}

	public void addEth(Eth eth) {
		if (eths.containsKey(eth.getName())) {
			system.out("Eth " + eth.getName() + " is already installed");
		}
		eths.put(eth.getName(), eth);
	}

	public Map<String, Eth> getEths() {
		return eths;
	}

	public IP getGateway() {
		return gateway;
	}

	public void setGateway(IP gateway) {
		this.gateway = gateway;
	}

	public IP getDns() {
		return dns;
	}

	public void setDns(IP dns) {
		this.dns = dns;
	}

	public Map<IP, Eth> getArp() {
		return arp;
	}

	public void setArp(Map<IP, Eth> arp) {
		this.arp = arp;
	}

	public Dhcp getDhcp(Network network) {
		return dhcp.get(network);
	}
	
	public Map<Network, Dhcp> getDhcps() {
		return dhcp;
	}

	public void setDhcp(Network network, Dhcp dhcp) {
		this.dhcp.put(network, dhcp);
	}

	public Dns getDnsConfiguration() {
		return dnsConfiguration;
	}
	public Email getEmail() {
		return email;
	}

	public Http getHttp() {
		return http;
	}

	public void setEmail(Email email) {
		this.email = email;
	}

	public void setHttp(Http http) {
		this.http = http;
	}

	public void setDnsConfiguration(Dns dnsConfiguration) {
		this.dnsConfiguration = dnsConfiguration;
	}

	public Sys getSystem() {
		return system;
	}

	public void setSystem(Sys system) {
		this.system = system;
	}
	
	public List<Eth> getSortedEths() {
		List<Eth> list = new ArrayList<Eth>(eths.values());
		Collections.sort(list);
		return list;
	}

	@Override
	public int compareTo(Host o) {
		return this.getName().compareTo(o.getName());
	}
}
