package net.ouska.networking;

import java.util.HashMap;
import java.util.Map;

public class Http {

	private Map<String, String> files = new HashMap<String, String>();
	private final Host host;
	
	public Http(Host host) {
		super();
		this.host = host;
	}

	public void addFile(String name, String content) {
		files.put(name, content);
	}

	public void removeFile(String name) {
		files.remove(name);
	}
	
	public Map<String, String> getFiles() {
		return files;
	}

	public Host getHost() {
		return host;
	}

	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("HTTP server configuration:");
		for (String fileName : files.keySet()) {
			b.append("\n\t\t" + fileName);
		} 
		return b.toString();
	}	
}
