package net.ouska.networking;

public class IP {

	private final int a;
	private final int b;
	private final int c;
	private final int d;

	public IP(int a, int b, int c, int d) {
		this.a = a;
		this.b = b;
		this.c = c;
		this.d = d;
		if (a < 0 || a > 255 || b < 0 || b > 255 || c < 0 || c > 255 || d < 0 || d > 255) {
			throw new RuntimeException("Wrong IP format " + this);
		}
	}
	
	public IP(String address) {
		try {
			String[] parts = address.split("\\.");
			this.a = Integer.valueOf(parts[0]);
			this.b = Integer.valueOf(parts[1]);
			this.c = Integer.valueOf(parts[2]);
			this.d = Integer.valueOf(parts[3]);
		} catch (Exception e) {
			throw new RuntimeException("Wrong IP format " + address, e);
		}
		if (a < 0 || a > 255 || b < 0 || b > 255 || c < 0 || c > 255 || d < 0 || d > 255) {
			throw new RuntimeException("Wrong IP format " + address);
		}
	}

	@Override
	public int hashCode() {
		return getAddress().hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		return (obj instanceof IP) && getAddress().equals(((IP)obj).getAddress());
	}

	public String getAddress() {
		return a + "." + b + "." + c + "." + d;
	}

	@Override
	public String toString() {
		return getAddress();
	}

	public int getA() {
		return a;
	}

	public int getB() {
		return b;
	}

	public int getC() {
		return c;
	}

	public int getD() {
		return d;
	}

	public static boolean isValidIP(String ip) {
		try {
			new IP(ip);
			return true;
		} catch (Exception e) {
			return false;
		}
	}

}
