package net.ouska.networking;

import java.util.Random;

public class MAC {

	public final static MAC BROADCAST = new MAC("BROADCAST");
	public final static Random rnd = new Random(System.currentTimeMillis());
	
	private String address;

	public MAC(String address) {
		this.address = address;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	@Override
	public String toString() {
		return address;
	}

	@Override
	public int hashCode() {
		return address.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		return (obj instanceof MAC) && address.equals(((MAC)obj).address);
	}
	
	public static MAC generateMac(Sys system) {
		String chars = "ABCDEF0123456789";
		for (int i = 0; i < 100; i++) {
			MAC mac = new MAC("" +
					chars.charAt(rnd.nextInt(chars.length())) +
					chars.charAt(rnd.nextInt(chars.length())) +
					":" +
					chars.charAt(rnd.nextInt(chars.length())) +
					chars.charAt(rnd.nextInt(chars.length())));
				if (checkUnique(system, mac)) {
					return mac;
				}	
		}
		throw new RuntimeException("New UNIQUE MAC cannot be generated");
	}
	
	private static boolean checkUnique(Sys system, MAC mac) {
		for (Host host : system.hosts.values()) {
			for (Eth eth : host.getEths().values()) {
				if (eth.getMac().equals(mac)) {
					return false;
				}
			}
		}
		return true;
	}
}
