package net.ouska.networking;

import java.util.HashMap;
import java.util.Map;

public class Network implements Comparable<Network> {

	private final Map<MAC, Eth> eths = new HashMap<MAC, Eth>();
	private final Sys system;
	private final String name;
	public int x = -1;
	public int y = -1;

	public Network(Sys system, String name) {
		super();
		this.system = system;
		this.name = name;
	}
	
	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("Network ");
		b.append(name);
		for (Eth eth : eths.values()) {
			b.append("\n\t");
			b.append(eth.getHost().getName());
			b.append("\t"+eth.getName());
			if (eth.getMac() != null) {
				b.append("\t"+eth.getMac());
			}
			if (eth.getIp() != null) {
				b.append("\t"+eth.getIp());	
			}
			if (eth.getMask() != null) {
				b.append("\t"+eth.getMask());	
			}
			if (eth.isActive()) {
				b.append("\tENABLED");
			} else {
				b.append("\tDISABLED");
			}
		}
		return b.toString();
	}

	public void attach(Eth eth) {
		eth.setNetwork(this);
		eths.put(eth.getMac(), eth);
	}

	public void deattach(Eth eth) {
		eth.setNetwork(null);
		eths.remove(eth.getMac());
	}

	public Map<MAC, Eth> getEths() {
		return eths;
	}

	public Eth getEth(MAC mac) {
		return eths.get(mac);
	}

	public Sys getSystem() {
		return system;
	}

	public String getName() {
		return name;
	}

	@Override
	public int compareTo(Network o) {
		return this.getName().compareTo(o.getName());
	}
}
