package net.ouska.networking;

import java.util.ArrayList;
import java.util.List;

public class Options {

	final List<String> options = new ArrayList<String>();

	public Options(String line) {
		line = line.replaceAll("\\s+"," ").trim();		
		String[] parts = line.split(" ");
		for (String part : parts) {
			options.add(part);
		} 
	}

	public String restOfTheLine(int from) {
		StringBuilder b = new StringBuilder();
		for (int i = from; i < options.size(); i++) {
			if (b.length() > 0) {
				b.append(" ");	
			}
			b.append(options.get(i));
		} 
		return b.toString();
	}

	public int count() {
		return options.size() - 1;
	}
	
	public String opt0() {
		return options.get(0);
	}

	public boolean has0() {
		return options.size() > 0;
	}

	public boolean opt0(String value) {
		return has0() && opt0().equalsIgnoreCase(value);
	}

	public String opt1() {
		return options.get(1);
	}
	
	public IP opt1IP() {
		return new IP(opt1());
	}

	public boolean has1() {
		return options.size() > 1;
	}

	public boolean is1IP() {
		try {
			has1(); 
			new IP(opt1());
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	public boolean opt1(String value) {
		return has1() && opt1().equalsIgnoreCase(value);
	}

	public String opt2() {
		return options.get(2);
	}
	
	public IP opt2IP() {
		return new IP(opt2());
	}

	public int opt2Integer() {
		return Integer.valueOf(opt2());
	}

	public boolean has2() {
		return options.size() > 2;
	}

	public boolean is2IP() {
		return has2() && IP.isValidIP(opt2());
	}

	public boolean is2Integer() {
		try {
			Integer.valueOf(opt2());
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	public boolean opt2(String value) {
		return has2() && opt2().equalsIgnoreCase(value);
	}

	public String opt3() {
		return options.get(3);
	}

	public boolean opt3(String value) {
		return has3() && opt3().equalsIgnoreCase(value);
	}

	public boolean has3() {
		return options.size() > 3;
	}
	
	public boolean is3IP() {
		return has3() && IP.isValidIP(opt3());
	}

	public IP opt3IP() {
		return new IP(opt3());
	}

	
	
	public String opt4() {
		return options.get(4);
	}

	public boolean opt4(String value) {
		return has4() && opt4().equalsIgnoreCase(value);
	}

	public boolean has4() {
		return options.size() > 4;
	}
	
	public boolean is4IP() {
		return has4() && IP.isValidIP(opt4());
	}

	public IP opt4IP() {
		return new IP(opt4());
	}


	
	public String opt5() {
		return options.get(5);
	}

	public boolean opt5(String value) {
		return has5() && opt5().equalsIgnoreCase(value);
	}

	public boolean has5() {
		return options.size() > 5;
	}
	
	public boolean is5IP() {
		return has5() && IP.isValidIP(opt5());
	}

	public IP opt5IP() {
		return new IP(opt5());
	}

	
	
	public String opt6() {
		return options.get(6);
	}

	public boolean opt6(String value) {
		return has6() && opt6().equalsIgnoreCase(value);
	}

	public boolean has6() {
		return options.size() > 6;
	}
	
	public boolean is6IP() {
		return has6() && IP.isValidIP(opt6());
	}

	public IP opt6IP() {
		return new IP(opt6());
	}

	
	
	public List<String> options() {
		return new ArrayList<String>(options);
	}
	
}
