package net.ouska.networking.command;

import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;

public abstract class Command {

	protected final Sys system;
	protected final Sys template;
	protected final String name;

	public Command(Sys system, Sys template, String name) {
		super();
		this.system = system;
		this.template = template;
		this.name = name;
	}
	

	public abstract void perform(Options options);
	
	public void out(String str) {
		system.out(str);
	}


	public String getName() {
		return name;
	}

	public Hint createHint() {
		return new Keyword(getName());
	}

}
