package net.ouska.networking.command;

import net.ouska.networking.Host;
import net.ouska.networking.IP;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;

public class HostCommandArp extends HostCommand {

	public HostCommandArp(Sys system, Sys template, Host host) {
		super(system, template, "arp", host);
	}
	

	public void perform(Options op) {
		out("ARP table");
		for (IP ip : host.getArp().keySet()) {
			out("\t" + ip + " -> " + host.getArp().get(ip).getMac());
		}
	}
	
}
