package net.ouska.networking.command;

import net.ouska.networking.Dhcp;
import net.ouska.networking.Eth;
import net.ouska.networking.Host;
import net.ouska.networking.IP;
import net.ouska.networking.MAC;
import net.ouska.networking.Network;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;
import net.ouska.networking.hint.Param;

public class HostCommandDhcp extends HostCommand {

	public HostCommandDhcp(Sys system, Sys template, Host host) {
		super(system, template, "dhcp", host);
	}

	public void perform(Options op) {
		if (host.getDhcps().isEmpty()) {
			out("DHCP not installed!");
			return;
		}
		
		if (!op.has1()) {
			for (Network network : host.getDhcps().keySet()) {
				Dhcp dhcp = host.getDhcp(network);
				out(dhcp.toString());	
			}
			return;
		}
		String networkName = op.opt1();
		Network network = system.networks.get(networkName);
		if (network == null) {
			out("Unknown network!");
			return;
		}
		Dhcp dhcp = host.getDhcp(network);
		if (dhcp == null) {
			out("DHCP not installed for network "+networkName+"!");
			return;
		}
		
		if (!op.has2()) {
			out(dhcp.toString());
			return;
		}
		if (op.opt2("add")) {
			if (!op.has3()) {
				out("MAC address is missing!");
				return;
			} else if (!op.is4IP()) {
           		out("IP address is missing!");
				return;
			} else {
				MAC mac = new MAC(op.opt3());
				IP ip = op.opt4IP();
				dhcp.getTable().put(mac, ip);
				out("MAC -> IP dhcp mapping set.");
			}
			return;
		} else if (op.opt2("remove")) {
			if (!op.has3()) {
				out("MAC address is missing!");
				return;
			}
			MAC mac = new MAC(op.opt3());
			dhcp.getTable().remove(mac);
			out("MAC -> IP dhcp mapping removed.");
		} else {
			out("Unknown dhcp option! - use ADD or REMOVE");
		}
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		
		Keyword add = new Keyword("add");
		
		
		Param pIp  = new Param("IP");
		
		for (Host host : system.hosts.values()) {
			for (Eth eth : host.getEths().values()) {
				Keyword pMAC = new Keyword(eth.getMac().toString());
				add.add(pMAC);
				pMAC.add(pIp);
			}
		}
		
		Keyword remove = new Keyword("remove");
		for (Host host : system.hosts.values()) {
			for (Eth eth : host.getEths().values()) {
				Keyword pMAC = new Keyword(eth.getMac().toString());
				remove.add(pMAC);
			}
		}
		
		for (Network net : host.getDhcps().keySet()) {
			Keyword network = new Keyword(net.getName());
			root.add(network);
			network.add(add);
			network.add(remove);
		}
		
		return root;
	}
	
}
