package net.ouska.networking.command;

import net.ouska.networking.Dns;
import net.ouska.networking.Host;
import net.ouska.networking.IP;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;
import net.ouska.networking.hint.Param;

public class HostCommandDns extends HostCommand {

	public HostCommandDns(Sys system, Sys template, Host host) {
		super(system, template, "dns", host);
	}
	
	public void perform(Options op) {
		Dns dns = host.getDnsConfiguration();
		if (dns == null) {
			out("DNS not installed!");
			return;
		}
		if (!op.has1()) {
			out(dns.toString());
			return;
		}
		if (op.opt1("add")) {
			if (!op.has2()) {
				out("HostName missing!");
				return;
			}
			if (!op.is3IP()) {
				out("Host IP missing!");
				return;
			}
			String name = op.opt2();
			IP ip = op.opt3IP();
			dns.getTable().put(name, ip);
			out("HostName -> IP dns mapping added.");
			return;
		} else if (op.opt1("remove")) {
			if (!op.has2()) {
				out("HostName missing!");
				return;
			}
			dns.getTable().remove(op.opt2());
			out("HostName -> IP dns mapping removed.");
		} else {
			out("Unkonwn dns option! - use ADD or REMOVE");
		}
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		
		Keyword add = new Keyword("add");
		Param pMAC = new Param("HOSTNAME");
		pMAC.add(new Param("IP"));
		add.add(pMAC);
		
		Keyword remove = new Keyword("remove");
		if (host.getDnsConfiguration() != null) {
			for (String hostname : host.getDnsConfiguration().getTable().keySet()) {
				remove.add(new Keyword(hostname));	
			}
		} else {
			remove.add(new Param("HOSTNAME"));
		}
		
		root.add(add);
		root.add(remove);
		
		return root;
	}
	
}
