package net.ouska.networking.command;

import java.util.List;

import net.ouska.networking.Communication;
import net.ouska.networking.Host;
import net.ouska.networking.IP;
import net.ouska.networking.Message;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.gui.Animation;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;
import net.ouska.networking.hint.Param;

public class HostCommandEmail extends HostCommand {

	public HostCommandEmail(Sys system, Sys template, Host host) {
		super(system, template, "email", host);
	}

	public void perform(Options op) {
		if (!op.opt1("read") && !op.opt1("send")) {
			out("Missing READ or SEND keyword!");
			return;
		}
		String method = op.opt1();

		if (!op.has2()) {
			out("Missing recipient!");
			return;
		}

		String[] parts = op.opt2().split("@");
		if (parts.length < 2) {
			out("Recipient is not valid!");
			return;
		}
		String recipient = parts[0];
		String hostName = parts[1];

		if (!op.opt1("read") && !op.opt1("send")) {
			out("Missing READ or SEND keyword!");
			return;
		}

		String message = "";
		if (op.opt1("send")) {
			if (!op.has3()) {
				out("Message missing!");
				return;
			} else {
				message = op.restOfTheLine(3);	
			}
		}
		
		Animation.reset();
		try {
			IP ip = Communication.dnsLookup(system, host, hostName);
	
			Message emailRequest = new Message(ip);
			out("Email "+ method+" request to " + emailRequest.getDest() + " ...");
			try {
				Host targetHost = Communication.sendOverInternet(host, emailRequest);
				system.debug(targetHost.getName() + ": Got EMAIL request... replying with content");
				Message emailResponse = new Message(emailRequest.getSrc());
				Host targetHost2 = Communication.sendOverInternet(targetHost, emailResponse);
				if (targetHost2 == null || !targetHost2.equals(host)) {
					throw new RuntimeException("Error while requesting email server");
				}
				if (targetHost.getEmail() == null) {
					throw new RuntimeException("EMAIL server is not installed on " + emailRequest.getDest());
				}
				if (method.equalsIgnoreCase("read")) {
					out("Email response from " + emailRequest.getDest() + " time=3ms");
					List<String> messages = targetHost.getEmail().getMessages().get(recipient);
					if (messages == null || messages.isEmpty()) {
						out("\tYou have no new emails");
					} else {
						out("\tYou have " + messages.size() + " new emails");
						for (String email : messages) {
							out("\t"+email);	
						}
						messages.clear();
					}
				} else if (method.equalsIgnoreCase("send")) {
					targetHost.getEmail().addMessage(recipient, message);
					out("Email response 200 OK from " + emailRequest.getDest() + " time=3ms");
				} 
				
			} catch (Exception e) {
				if (e.getMessage() != null) {
					out(e.getMessage());
				} else {
					e.printStackTrace();
				}
			}
		} finally {
			Animation.play(system);	
		}
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		Keyword read = new Keyword("read");
		Keyword send = new Keyword("send");
		root.add(read);
		root.add(send);
		
		read.add(new Param("RECIPIENT"));

		Param hostname = new Param("RECIPIENT");
		hostname.add(new Param("MESSAGE"));
		send.add(hostname);
		
		return root;
	}
	
}
