package net.ouska.networking.command;

import net.ouska.networking.Communication;
import net.ouska.networking.Dhcp;
import net.ouska.networking.Eth;
import net.ouska.networking.Host;
import net.ouska.networking.IP;
import net.ouska.networking.MAC;
import net.ouska.networking.Message;
import net.ouska.networking.Network;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.gui.Animation;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;
import net.ouska.networking.hint.Param;

public class HostCommandHttp extends HostCommand {

	public HostCommandHttp(Sys system, Sys template, Host host) {
		super(system, template, "http", host);
	}

	public void perform(Options op) {
		if (!op.opt1("get") && !op.opt1("put")) {
			out("Missing GET or PUT keyword!");
			return;
		}
		String method = op.opt1();
		
		if (!op.has2()) {
			out("Missing URL!");
			return;
		}

		String[] parts = op.opt2().split("/", 2);
		if (parts.length < 2) {
			out("Invalid URL!");
			return;
		}
		String hostName = parts[0];
		String resourceName = parts[1];
		
		Animation.reset();
		try {
			IP ip = Communication.dnsLookup(system, host, hostName);
			
			String resourceContent = "";
			if (method.equalsIgnoreCase("put")) {
				if (!op.has3()) {
					out("Resource content missing!");
					return;
				} else {
					resourceContent = op.restOfTheLine(3);	
				}
			}
			
			Message httpRequest = new Message(ip);
			out("Http request to " + httpRequest.getDest() + " ...");
			try {
				Host targetHost = Communication.sendOverInternet(host, httpRequest);
				Message httpResponse = new Message(httpRequest.getSrc());
				system.debug(targetHost.getName() + ": Got HTTP request... replying with content");
				
				Host targetHost2 = Communication.sendOverInternet(targetHost, httpResponse);
				if (targetHost2 == null || !targetHost2.equals(host)) {
					throw new RuntimeException("Error while requesting http server");
				}
				if (targetHost.getHttp() == null) {
					throw new RuntimeException("HTTP server is not installed on " + httpRequest.getDest());
				}
				if (method.equalsIgnoreCase("get")) {
					String content = targetHost.getHttp().getFiles().get(resourceName);
					if (content == null) {
						throw new RuntimeException("HTTP response 404 - resource not found!");
					}
					out("Http response from " + httpRequest.getDest() + " time=3ms");
					out("\t"+content);
				} else if (method.equalsIgnoreCase("put")) {
					targetHost.getHttp().getFiles().put(resourceName, resourceContent);
					out("Http response 200 OK from " + httpRequest.getDest() + " time=3ms");
				} 
				
			} catch (Exception e) {
				if (e.getMessage() != null) {
					out(e.getMessage());
				} else {
					e.printStackTrace();
				}
			}
		} finally {
			Animation.play(system);	
		}
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		Keyword get = new Keyword("get");
		Keyword put = new Keyword("put");
		root.add(get);
		root.add(put);
		
		get.add(new Param("URL"));

		Param hostname = new Param("URL");
		hostname.add(new Param("FILE_CONTENT"));
		put.add(hostname);
		
		return root;
	}
	
}
