package net.ouska.networking.command;

import net.ouska.networking.Dhcp;
import net.ouska.networking.Dns;
import net.ouska.networking.Email;
import net.ouska.networking.Host;
import net.ouska.networking.Http;
import net.ouska.networking.IP;
import net.ouska.networking.Network;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;
import net.ouska.networking.hint.Param;

public class HostCommandInstall extends HostCommand {

	public HostCommandInstall(Sys system, Sys template, Host host) {
		super(system, template, "install", host);
	}

	public void perform(Options op) {
		if (!op.has1()) {
			out("Service name missing!");
			return;
		} else if (op.opt1("dhcp")) {
			if (!op.has2()) {
				out("Missing network name!");
				return;
			}
			Network network = system.networks.get(op.opt2());
			if (network == null) {
				out("Wrong network name!");
				return;
			}
			if (!op.is3IP()) {
				out("First IP of the DHCP pool missing!");
				return;
			}
			IP ip = op.opt3IP();
			IP mask = new IP("255.255.255.0");
			IP gateway = null;
			IP dns = null;
			if (op.is4IP()) {
				mask = op.opt4IP();
			}
			if (op.is5IP()) {
				gateway = op.opt5IP();
			}
			if (op.is6IP()) {
				dns = op.opt6IP();
			}
			Dhcp dhcp = new Dhcp(host, ip, mask, gateway, dns);
			host.setDhcp(network, dhcp);
			out("DHCP server installed.");
		} else if (op.opt1("dns")) {
			host.setDnsConfiguration(new Dns(host));
			out("DNS server installed.");
		} else if (op.opt1("http")) {
			host.setHttp(new Http(host));
			out("Http server installed.");
		} else if (op.opt1("email")) {
			host.setEmail(new Email(host));
			out("Email server installed.");
		} else {
			out("Unknown service name.");
		}
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		
		Keyword dhcp = new Keyword("dhcp");
		
		Param pip = new Param("IP - POOL START");
		Param pmask = new Param("MASK");
		Param gateway = new Param("GATEWAY");
		Param dns = new Param("DNS");

		pip.add(pmask);
		pmask.add(gateway);
		gateway.add(dns);
		
		for (String networkName : system.networks.keySet()) {
			Keyword network = new Keyword(networkName);
			dhcp.add(network);
			network.add(pip);
		}
		
		root.add(dhcp);
		root.add(new Keyword("dns"));
		root.add(new Keyword("email"));
		root.add(new Keyword("http"));
		return root;
	}
	
}
