package net.ouska.networking.command;

import net.ouska.networking.Eth;
import net.ouska.networking.Host;
import net.ouska.networking.IP;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;
import net.ouska.networking.hint.Param;

public class HostCommandIpconfig extends HostCommand {

	public HostCommandIpconfig(Sys system, Sys template, Host host) {
		super(system, template, "ipconfig", host);
	}
	
	public void perform(Options op) {
		if (!op.has1()) {
			out(host.toString());
			return;
		} else if (op.opt1("gateway")) {
			if (!op.has2()) {
				out("IP address missing!");
				return;
			}
			if (!op.is2IP()) {
				out("Invalid IP address " + op.opt2() + "!");
				return;
			}
			host.setGateway(op.opt2IP());
			out("Gateway configured.");
			return;
		} else if (op.opt1("dns")) {
			if (!op.has2()) {
				out("IP address missing!");
				return;
			}
			if (!op.is2IP()) {
				out("Invalid IP address " + op.opt2() + "!");
				return;
			}
			host.setDns(op.opt2IP());
			out("DNS configured.");
			return;
		} else {
			Eth eth = host.getEth(op.opt1());
			if (eth == null) {
				out("Invalid eth name " + op.opt1() + "!");
				return;
			}
			if (!op.has2()) {
				out("IP address or DHCP flag missing!");
				return;
			}
			if (op.opt2("dhcp")) {
				eth.setDhcp(true);
				eth.setIp(null);
				eth.setMask(null);
				out("DHCP flag has been set");
				eth.reload();
				return;
			} else if (op.opt2("enable")) {
				eth.tryToEnable();
				return;
			} else if (op.opt2("disable")) {				
				eth.setActive(false);
				out(eth.getName() + " disabled.");
				return;
			}
			
			if (!op.is2IP()) {
				out("Invalid IP address " + op.opt2() + "!");
				return;
			}
			if (!op.has3()) {
				eth.setIp(op.opt2IP());
				eth.setMask(new IP("255.255.255.0"));
				eth.setDhcp(false);
				out("IP address configured.");
				eth.reload();
				return;
			} else {
				if (!op.is3IP()) {
					out("Invalid mask " + op.opt3() + "!");
					return;
				}
				eth.setIp(op.opt2IP());
				eth.setMask(op.opt3IP());
				eth.setDhcp(false);
				out("IP address configured.");
				eth.reload();
				return;
			}
		}
	}

	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		Keyword gateway = new Keyword("gateway");
		gateway.add(new Param("IP"));
		
		Keyword dns = new Keyword("dns");
		dns.add(new Param("IP"));
		
		root.add(gateway);
		root.add(dns);
		
		for (Eth eth : host.getEths().values()) {
			Keyword keth = new Keyword(eth.getName());
			root.add(keth);
			
			keth.add(new Keyword("dhcp"));
			keth.add(new Keyword("enable"));
			keth.add(new Keyword("disable"));
			
			Param ip = new Param("IP");
			keth.add(ip);
			
			ip.add(new Param("MASK"));
		}
		
		return root;
	}
	
	
}
