package net.ouska.networking.command;

import net.ouska.networking.Communication;
import net.ouska.networking.Host;
import net.ouska.networking.IP;
import net.ouska.networking.Message;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.gui.Animation;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;
import net.ouska.networking.hint.Param;

public class HostCommandPing extends HostCommand {

	public HostCommandPing(Sys system, Sys template, Host host) {
		super(system, template, "ping", host);
	}
	
	public void perform(Options op) {
		if (!op.has1()) {
			out("IP or HostName missing!");
			return;
		}
		
		Animation.reset();
		try {		
				IP ip = Communication.dnsLookup(system, host, op.opt1());
				
				Message ping = new Message(ip);
				out("Pinging " + ping.getDest() + " ...");
				try {
					Host targetHost = Communication.sendOverInternet(host, ping);
					system.debug(targetHost.getName() + ": Got Ping... replying with Pong");
					Message pong = new Message(ping.getSrc());
					Host targetHost2 = Communication.sendOverInternet(targetHost, pong);
					if (targetHost2 == null || !targetHost2.equals(host)) {
						throw new RuntimeException("Error while delivering ping-pong");
					}
					
					out("Reply from " + ping.getDest() + " time=3ms");
				} catch (Exception e) {
					if (e.getMessage() != null) {
						out(e.getMessage());
					} else {
						e.printStackTrace();
					}
				}
		} finally {
			Animation.play(system);
		}		
		
	}

	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		root.add(new Param("IP/HOSTNAME"));
		return root;
	}
	
}
