package net.ouska.networking.command;

import net.ouska.networking.Dhcp;
import net.ouska.networking.Host;
import net.ouska.networking.Network;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;

public class HostCommandUninstall extends HostCommand {

	public HostCommandUninstall(Sys system, Sys template,  Host host) {
		super(system, template, "uninstall", host);
	}

	public void perform(Options op) {
		if (!op.has1()) {
			out("Service name missing!");
			return;
		} else if (op.opt1("dhcp")) {
			if (host.getDhcps().isEmpty()) {
				out("DHCP server is not installed!");
			} else {
				if (!op.has2()) {
					out("Network name missing!");
					return;
				}
				
				Network network = system.networks.get(op.opt2());
				if (network == null) {
					out("Unknown network!");
					return;
				}
				Dhcp dhcp = host.getDhcp(network);
				if (dhcp == null) {
					out("DHCP is not installed for network " + network.getName() + "!");
					return;
				}
				
				host.getDhcps().remove(network);	
				out("DHCP server uninstalled for network " + network.getName() + ".");	
			}
			
		} else if (op.opt1("dns")) {
			if (host.getDnsConfiguration() == null) {
				out("DNS server is not installed!");
			} else {
				host.setDnsConfiguration(null);
				out("DNS server uninstalled.");
			}
		} else if (op.opt1("http")) {
			if (host.getHttp() == null) {
				out("HTTP server is not installed!");
			} else {
				host.setHttp(null);
				out("HTTP server uninstalled.");
			}
		} else if (op.opt1("email")) {
			if (host.getEmail() == null) {
				out("EMAIL server is not installed!");
			} else {
				host.setEmail(null);
				out("EMAIL server uninstalled.");
			}
		} else {
			out("Unknown service.");
		}
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		Keyword kw = new Keyword("dhcp");
		root.add(kw);
		for (Network network : host.getDhcps().keySet()) {
			kw.add(new Keyword(network.getName()));	
		}
		root.add(new Keyword("dns"));
		root.add(new Keyword("email"));
		root.add(new Keyword("http"));
		return root;
	}
	
}
