package net.ouska.networking.command;

import net.ouska.networking.Eth;
import net.ouska.networking.Host;
import net.ouska.networking.Network;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;

public class SystemCommandAttach extends SystemCommand {

	public SystemCommandAttach(Sys system, Sys template) {
		super(system, template, "attach");
	}

	public void perform(Options op) {
		if (!op.has1()) {
			out("Host name missing!");
			return;
		}

		Host host = system.hosts.get(op.opt1());
		if (host == null) {
			out("Unknown host " + op.opt1() + "!");
			return;
		}
		
		if (!op.opt2("to")) {
			out("Keyword 'to' missing!");
			return;
		}

		if (!op.has3()) {
			out("Network name missing!");
			return;
		}

		Network network = system.networks.get(op.opt3());
		if (network == null) {
			out("Unknown network " + op.opt3() + "!");
			return;
		}
		
		if (!op.opt4("using")) {
			out("Keyword 'using' missing!");
			return;
		}

		if (!op.has5()) {
			out("Card name (eth) missing!");
			return;
		}

		Eth eth = host.getEth(op.opt5());
		if (eth == null) {
			out("Unknown network card (eth) " + op.opt5() + "!");
			return;
		}

		system.attach(eth, network);
		out("Host " + host.getName() + " attached to " + network.getName() + " using " + eth.getName());
	}

	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		for (Host h : system.hosts.values()) {
			Keyword host = new Keyword(h.getName());
			root.add(host);
			Keyword to = new Keyword("to");
			host.add(to);
			for (Network n : system.networks.values()) {
				Keyword network = new Keyword(n.getName());
				to.add(network);
				Keyword using = new Keyword("using");	
				network.add(using);
				for (Eth e : h.getSortedEths()) {
					Keyword eth = new Keyword(e.getName());
					using.add(eth);
				}
			}
		}
		return root;
	}
}
