package net.ouska.networking.command;

import net.ouska.networking.Host;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Hostname;

public class SystemCommandConnect extends SystemCommand {

	public SystemCommandConnect(Sys system, Sys template) {
		super(system, template, "connect");
	}
	

	public void perform(Options op) {
		if (!op.has1()) {
			out("host not specified!");
			return;
		} 
		Host host = system.hosts.get(op.opt1());
		if (host == null) {
			out("Unknown host " + op.opt1());
			return;
		} 
		system.setActiveHost(host);
		out("Connected to " + host.getName() + ".");
	}

	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		for (Host host : system.hosts.values()) {
			Hostname hostname = new Hostname(host.getName());
			root.add(hostname);
		}
		return root;
	}
	
}
