package net.ouska.networking.command;

import net.ouska.networking.Eth;
import net.ouska.networking.Host;
import net.ouska.networking.MAC;
import net.ouska.networking.Network;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;
import net.ouska.networking.hint.Param;

public class SystemCommandCreate extends SystemCommand {

	public SystemCommandCreate(Sys system, Sys template) {
		super(system, template, "create");
	}

	public void perform(Options op) {
		if (!op.has1()) {
			out("Component missing!");
			return;
		}
		
		if (op.opt1("host")) {
			if (!op.has2()) {
				out("Host name missing!");
				return;
			}
			if (system.hosts.containsKey(op.opt2())) {
				out("Invlaid host name. Host " + op.opt2() + " already exists!");
				return;
			}
			Host host = new Host(system, op.opt2());
			if (op.has3()) {
				Eth eth = new Eth(host, op.opt3(), MAC.generateMac(system));
				host.addEth(eth);
			} else {
				Eth eth = new Eth(host, "eth1", MAC.generateMac(system));
				host.addEth(eth);
			}
			if (op.has4()) {
				Eth eth = new Eth(host, op.opt4(), MAC.generateMac(system));
				host.addEth(eth);
			}
			if (op.has5()) {
				Eth eth = new Eth(host, op.opt5(), MAC.generateMac(system));
				host.addEth(eth);
			}
			system.addHost(host);	
			out("Host " + host.getName() + " created.");
		} else if (op.opt1("network")) {
			if (!op.has2()) {
				out("Network name missing!");
				return;
			}
			Network n =  new Network(system, op.opt2());
			system.addNetwork(n);
			out("Network " + n.getName() + " created.");	
		} else {
			out("Unknown component!");
		}
	}

	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		
		Keyword host = new Keyword("host");
		Param hostName = new Param("NAME");
		Param eth = new Param("ETH");
		hostName.add(eth);
		host.add(hostName);

		Keyword network = new Keyword("network");
		Param networkName = new Param("NAME");
		network.add(networkName);

		root.add(host);
		root.add(network);
		return root;
	}
	
}
