package net.ouska.networking.command;

import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;

public class SystemCommandDebug extends SystemCommand {

	public SystemCommandDebug(Sys system, Sys template) {
		super(system, template, "debug");
	}
	

	public void perform(Options op) {
		if (!op.has1()) {
			out("on/off not specified!");
			return;
		} 
		
		if (op.opt1("on")) {
			system.debugCommunication = true;
			out("Communication debugging is ON!");
		} else if (op.opt1("off")) {
			system.debugCommunication = false;
			out("Communication debugging is OFF!");
		} else {
			out("one of on/off must be specified!");
			return;
		}
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		root.add(new Keyword("on"));
		root.add(new Keyword("off"));
		return root;
	}
	
}
