package net.ouska.networking.command;

import net.ouska.networking.Host;
import net.ouska.networking.Network;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;

public class SystemCommandDelete extends SystemCommand {

	public SystemCommandDelete(Sys system, Sys template) {
		super(system, template, "delete");
	}

	public void perform(Options op) {
		if (!op.has1()) {
			out("Component missing!");
			return;
		}
		
		if (op.opt1("host")) {
			if (!op.has2()) {
				out("Host name missing!");
				return;
			}
			String hostName = op.opt2();
			Host host = system.hosts.get(hostName);
			if (host != null) {
				system.removeHost(host);
				out("Host " + host.getName() + " deleted.");
			} else {
				out("Unknow host " + hostName + "!");
			}
		} else if (op.opt1("network")) {
			if (!op.has2()) {
				out("Network name missing!");
				return;
			}
			
			String networkName = op.opt2();
			Network network = system.networks.get(networkName);
			if (network != null) {
				system.removeNetwork(network);
				out("Network " + network.getName() + " deleted.");
			} else {
				out("Unknow network " + networkName + "!");
			}
		} else if (op.opt1("all")) {
			system.deleteAll();
			out("The entire netowrk erased!");
		} else {
			out("Unknown component!");
		}
	}

	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		root.add(new Keyword("all"));
		Keyword host = new Keyword("host");
		for (Host h : system.hosts.values()) {
			host.add(new Keyword(h.getName()));
		}

		Keyword network = new Keyword("network");
		for (Network n : system.networks.values()) {
			network.add(new Keyword(n.getName()));
		}

		root.add(host);
		root.add(network);
		return root;
	}
	
}
