package net.ouska.networking.command;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.demo.DemoAccessor;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;

public class SystemCommandDemo extends SystemCommand {

	Map<String, List<Map<String, String>>> content;
	
	public SystemCommandDemo(Sys system, Sys template) {
		super(system, template, "demo");
		
		//File file = new File(DemoAccessor.class.getResource("projects").getFile());
		try (Scanner scanner = new Scanner(DemoAccessor.class.getResource("projects").openStream())) {
			content = SystemCommandLoad.readContent(scanner);	
		} catch (Exception e) {
			throw new RuntimeException("Error loading file demo projects" + "!", e);
		}
	}

	public void perform(Options op) {
		if (!op.has1()) {
			out("Demo network name missing!");
			return;
		}
		
		String fileName = null;
		String templateName = null;
		boolean found = false;
		for (Map<String, String> map : content.get("project")) {
			String name = map.get("name");
			if (op.opt1(name)) {
				fileName = map.get("filename");
				templateName = map.get("template");
				found = true;
				break;
			}
		}
		
		if (!found) {
			out("Unknown demo "+op.opt1()+"!");
			return;
		}
		
		
		if (fileName != null) {
			try (InputStream is = DemoAccessor.class.getResource(fileName).openStream()) {
				//File file = new File(DemoAccessor.class.getResource(fileName).getFile());
				SystemCommandLoad.loadConfigurationFromFile(system, is);
			} catch (IOException e) {
				throw new RuntimeException("Error loading file!", e);
			}
		}
		
		template.okno.setVisible(false);
		if (templateName != null) {
			try (InputStream is = DemoAccessor.class.getResource(templateName).openStream()) {
				//File file = new File(DemoAccessor.class.getResource(templateName).getFile());
				SystemCommandLoad.loadConfigurationFromFile(template, DemoAccessor.class.getResource(templateName).openStream());
				template.okno.setVisible(true);
			} catch (IOException e) {
				throw new RuntimeException("Error loading file!", e);
			}
		}
		
		system.console.requestFocus();
		system.console.txt.requestFocus();
		out("Demo configuration " + op.opt1() + " loaded");
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		for (Map<String, String> map : content.get("project")) {
			root.add(new Keyword(map.get("name")));	
		}
		return root;
	}
	
}
