package net.ouska.networking.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.ouska.networking.Host;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;

public class SystemCommandHosts extends SystemCommand {

	public SystemCommandHosts(Sys system, Sys template) {
		super(system, template, "hosts");
	}
	

	public void perform(Options op) {
		out("List of hosts:");
		

		List<String> list = new ArrayList<String>(system.hosts.keySet());
		Collections.sort(list);
		for (String name : list) {
			Host host = system.hosts.get(name);
			out(host.toString());
		}
	}
	
}
