package net.ouska.networking.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.ouska.networking.Network;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;

public class SystemCommandNetworks extends SystemCommand {

	public SystemCommandNetworks(Sys system, Sys template) {
		super(system, template, "networks");
	}
	

	public void perform(Options op) {
		out("List of networks:");
		

		List<String> list = new ArrayList<String>(system.networks.keySet());
		Collections.sort(list);
		for (String name : list) {
			Network host = system.networks.get(name);
			out(host.toString());
		}
	}
	
}
