package net.ouska.networking.command;

import net.ouska.networking.Host;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Hostname;

public class SystemCommandRestart extends SystemCommand {

	public SystemCommandRestart(Sys system, Sys template) {
		super(system, template, "restart");
	}
	

	public void perform(Options op) {
		if (!op.has1()) {
			out("host not specified!");
			return;
		} 
		if (op.opt1("all")) {
			out("Rebooting all hosts.");
			// Nejdrive nabootuju ty s DHCP
			for (String name : system.hosts.keySet()) {
				Host host = system.hosts.get(name);
				if (!host.getDhcps().isEmpty()) {
					out("Restarting host " + host.getName() + ".");
					host.restart();
				}
			}
			for (String name : system.hosts.keySet()) {
				Host host = system.hosts.get(name);
				if (host.getDhcps().isEmpty()) {
					out("Restarting host " + host.getName() + ".");
					host.restart();
				}
			}
			
			return;
		}
		if (op.has1()) {
			Host host = system.hosts.get(op.opt1());
			if (host == null) {
				out("Unknown host " + op.opt1());
				return;
			} 
			out("Restarting host " + host.getName() + ".");
			host.restart();
		}
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		root.add(new Hostname("all"));
		for (Host host : system.hosts.values()) {
			Hostname hostname = new Hostname(host.getName());
			root.add(hostname);
		}
		return root;
	}
	
}
