package net.ouska.networking.command;

import java.io.File;
import java.io.FileWriter;

import javax.swing.JFileChooser;

import net.ouska.networking.Dhcp;
import net.ouska.networking.Dns;
import net.ouska.networking.Email;
import net.ouska.networking.Eth;
import net.ouska.networking.Host;
import net.ouska.networking.Http;
import net.ouska.networking.IP;
import net.ouska.networking.MAC;
import net.ouska.networking.Network;
import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;

public class SystemCommandSave extends SystemCommand {

	public SystemCommandSave(Sys system, Sys template) {
		super(system, template, "save");
	}

	public void perform(Options op) {
		
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.setDialogTitle("Vyberte soubor");   
		int userSelection = fileChooser.showSaveDialog(system.console);
		if (userSelection != JFileChooser.APPROVE_OPTION) {
			return;
		}		
		File file = fileChooser.getSelectedFile();
		
		//File dir = Sys.getDefaultDirectory();;
		//File file = new File(dir, op.opt1() + ".ntw");
		if (file.exists()) {
			out("Filename " + file.getAbsolutePath() + "already exists!");
			return;
		}
		
		try (FileWriter fileWriter = new FileWriter(file)) {
			StringBuilder project = new StringBuilder();
			appendPair(project, "width", system.okno.getWidth());
			appendPair(project, "height", system.okno.getHeight());
			fileWriter.write("PROJECT;" + project.toString() + "\n");
		
			for (Network network : system.networks.values()) {
				StringBuilder b = new StringBuilder();
				appendPair(b, "name", network.getName());
				appendPair(b, "x", network.x);
				appendPair(b, "y", network.y);
				fileWriter.write("NETWORK;" + b.toString() + "\n");
			}
			for (Host host : system.hosts.values()) {
				StringBuilder b = new StringBuilder();
				appendPair(b, "name", host.getName());
				appendPair(b, "gateway", host.getGateway());
				appendPair(b, "dns", host.getDns());
				appendPair(b, "x", host.x);
				appendPair(b, "y", host.y);
				fileWriter.write("HOST;" + b.toString() + "\n");
				for (Eth eth : host.getEths().values()) {
					StringBuilder be = new StringBuilder();
					appendPair(be, "host", eth.getHost().getName());
					appendPair(be, "name", eth.getName());
					appendPair(be, "mac", eth.getMac());
					appendPair(be, "ip", eth.getIp());
					appendPair(be, "mask", eth.getMask());
					appendPair(be, "isActive", eth.isActive());
					appendPair(be, "isDhcp", eth.isDhcp());
					if (eth.getNetwork() != null) {
						appendPair(be, "network", eth.getNetwork().getName());	
					}
					fileWriter.write("ETH;" + be.toString() + "\n");
				}
				if (!host.getDhcps().isEmpty()) {
					for (Network network : host.getDhcps().keySet()) {
						Dhcp dhcp = host.getDhcp(network);
						StringBuilder be = new StringBuilder();
						appendPair(be, "network", network.getName());
						appendPair(be, "host", host.getName());
						appendPair(be, "counter", dhcp.getCounter());
						appendPair(be, "dns", dhcp.getDns());
						appendPair(be, "gateway", dhcp.getGateway());
						appendPair(be, "mask", dhcp.getMask());
						appendPair(be, "poolStart", dhcp.getPoolStart());
						fileWriter.write("DHCP;" + be.toString() + "\n");
						for (MAC mac : dhcp.getTable().keySet()) {
							be = new StringBuilder();
							IP ip = dhcp.getTable().get(mac); 
							appendPair(be, "host", host.getName());
							appendPair(be, "network", network.getName());
							appendPair(be, "mac", mac);
							appendPair(be, "ip", ip);
							fileWriter.write("DHCP-ENTRY;" + be.toString() + "\n");	
						}
					}
				}
				if (host.getDnsConfiguration() != null) {
					Dns dns = host.getDnsConfiguration();
					StringBuilder be = new StringBuilder();
					appendPair(be, "host", host.getName());
					fileWriter.write("DNS;" + be.toString() + "\n");
					for (String name : dns.getTable().keySet()) {
						be = new StringBuilder();
						appendPair(be, "host", host.getName());
						appendPair(be, "hostname", name);
						appendPair(be, "ip", dns.getTable().get(name));
						fileWriter.write("DNS-ENTRY;" + be.toString() + "\n");
					}
				}
				if (host.getEmail() != null) {
					Email email = host.getEmail();
					StringBuilder be = new StringBuilder();
					appendPair(be, "host", host.getName());
					fileWriter.write("EMAIL;" + be.toString() + "\n");
					for (String recipient : email.getMessages().keySet()) {
						for (String message : email.getMessages().get(recipient)) {
							be = new StringBuilder();
							appendPair(be, "host", host.getName());
							appendPair(be, "recipient", recipient);
							appendPair(be, "message", message);
							fileWriter.write("EMAIL-ENTRY;" + be.toString() + "\n");
						}
					}
				}
				if (host.getHttp() != null) {
					Http http = host.getHttp();
					StringBuilder be = new StringBuilder();
					appendPair(be, "host", host.getName());
					fileWriter.write("HTTP;" + be.toString() + "\n");
					for (String fileName : http.getFiles().keySet()) {
						be = new StringBuilder();
						String content = http.getFiles().get(fileName);
						appendPair(be, "host", host.getName());
						appendPair(be, "filename", fileName);
						appendPair(be, "content", content);
						fileWriter.write("HTTP-ENTRY;" + be.toString() + "\n");
					}
				}
			}
			out("Network configuration saved " + file.getAbsolutePath());
		} catch (Exception e) {
			throw new RuntimeException("Error while creating file " + file.getAbsolutePath() + "!");
		}
	}

	private void appendPair(StringBuilder b, String name, Object value) {
		if (b.length() > 0) {
			b.append(";");	
		} 
		b.append(name);
		b.append("=");
		if (value != null) {
			b.append(value);	
		}
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		return root;
	}
	
}
