package net.ouska.networking.command;

import net.ouska.networking.Options;
import net.ouska.networking.Sys;
import net.ouska.networking.hint.Hint;
import net.ouska.networking.hint.Keyword;

public class SystemCommandVisual extends SystemCommand {

	public SystemCommandVisual(Sys system, Sys template) {
		super(system, template, "visual");
	}

	public void perform(Options op) {
		if (op.opt1("auto")) {
			system.okno.setAutoPositioning(true);	
		} else if (op.opt1("mission")) {
			template.okno.setAutoPositioning(false);
			template.okno.setVisible(true);
		} else if (op.opt1("network")) {
			system.okno.setVisible(true);			
		} else {
			out("Keyword NETWORK or MISSION or AUTO missing!");
			return;
		}
		system.console.requestFocus();
		system.console.txt.requestFocus();
	}
	
	@Override
	public Hint createHint() {
		Hint root = super.createHint();
		root.add(new Keyword("auto"));
		root.add(new Keyword("mission"));
		root.add(new Keyword("network"));
		return root;
	}

}
