package net.ouska.networking.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.swing.SwingUtilities;

import net.ouska.networking.Eth;
import net.ouska.networking.Sys;

public class Animation {

	private long lastLinkActivity = System.currentTimeMillis() - 10000;
	private static final ExecutorService es = Executors.newCachedThreadPool();	
	private static final List<Frame> frames = new ArrayList<>();
	
	public synchronized static void reset() {
		frames.clear();
	}

	public synchronized static void add(Eth source, Eth destination) {
		frames.add(new Frame(source, destination));
	}

	public synchronized static void play(Sys system) {
		if (system.okno.isVisible()) {
			es.submit(new Runnable() {
				@Override
				public void run() {
					// synchronized (Animation.class) {
						try {
							for (Frame frame : frames) {
								frame.source.setTransmitting(true);
								refreshPanel(frame.source.getHost().getSystem());
								Thread.sleep(200);
								frame.source.setTransmitting(false);
								refreshPanel(frame.source.getHost().getSystem());
								Thread.sleep(100);
								frame.destination.setTransmitting(true);
								refreshPanel(frame.source.getHost().getSystem());
								Thread.sleep(200);
								frame.destination.setTransmitting(false);
								refreshPanel(frame.source.getHost().getSystem());
								Thread.sleep(100);
							}
						} catch (Exception e) {}
					// }
				}
			});
		}
	}

	private static void refreshPanel(Sys system) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				system.okno.repaint();
			}
		}); 		
	}
	
	private static class Frame {
		private Eth source;
		private Eth destination;
		public Frame(Eth source, Eth destination) {
			super();
			this.source = source;
			this.destination = destination;
		}
	}
}
