package net.ouska.networking.gui;

import java.awt.Graphics2D;
import java.awt.Point;

import net.ouska.networking.Sys;

public class Grid {

	private int[] horizontals;
	private int[] verticals;
	private Sys system;
	int cols;
	int rows;
	int cellHeight;
	int cellWidth;
	
	public Grid(Sys system, int width, int height) {
		this.system = system;
    	cols = Math.max(2 * system.networks.size() + 1, 3);
    	rows = 3;
    	int offsetH = Canvas.SIZE_HOST / 2;
    	//int offsetV = Canvas.SIZE_HOST / 2;
    	int offsetV = Canvas.SIZE_HOST;

    	cellHeight = (height - 2 * offsetV) / (rows - 1);
    	cellWidth = (width - 2 * offsetH) / (cols - 1);
    	horizontals = new int[cols];
    	verticals = new int[rows];
    	for (int i = 0; i < cols; i++) {
    		horizontals[i] = offsetH + i * cellWidth;
    	}
    	for (int i = 0; i < rows; i++) {
    		verticals[i] = offsetV + i * cellHeight;
    	}
	}
	
	public void draw(Graphics2D g) {
    	for (int x = 0; x < rows; x++) {
			for (int y = 0; y < cols; y++) {
				g.drawRect(horizontals[y], verticals[x], 1, 1);				
			}
		}
	}
	
	public int getCenterX(int column) {
		return horizontals[column];
	}
	
	public int getCenterY(int row) {
		return verticals[row];
	}

	public int getCellHeight() {
		return cellHeight;
	}

	public int getCellWidth() {
		return cellWidth;
	}
}
