package net.ouska.networking.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import net.ouska.networking.Console;
import net.ouska.networking.Dhcp;
import net.ouska.networking.Dns;
import net.ouska.networking.Eth;
import net.ouska.networking.Host;
import net.ouska.networking.IP;
import net.ouska.networking.MAC;
import net.ouska.networking.Network;
import net.ouska.networking.Sys;

public class Okno extends JFrame implements ActionListener {

	private Canvas panel;
	
	public Okno(Sys system, boolean readOnly) throws HeadlessException {
		super("Network");
		setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		setPreferredSize(new Dimension(500, 500));
		setLocation(200, 200);
		setLayout(new BorderLayout());
		panel = new Canvas(system, readOnly);
		getContentPane().add(panel, BorderLayout.CENTER);
		pack();
	}
	
	public void initHost(Host host) {
		if (host.x == -1) {
			host.x = getWidth() / 2 - Canvas.SIZE_HOST/2;
			host.y = getHeight() / 2 - Canvas.SIZE_HOST/2;
		}
	}

	public void initNetwork(Network network) {
		if (network.x == -1) {
			network.x = getWidth() / 2 - Canvas.NETWORK_WIDTH/2;
			network.y = getHeight() / 2 - Canvas.NETWORK_HEIGHT/2;
		}
	}

	public void onConfigurationChange() {
		panel.repaint();
	}

	public void refresh() {
		panel.repaint();
	}

	public void setAutoPositioning(boolean auto) {
		panel.setAutoPositioning(auto);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		
	}
	
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.invokeLater(new Runnable() {
		        @Override
		        public void run() {
		        	try {
		        		Console console = new Console();
		        		//console.setVisible(true);
		        		Sys system = new Sys(console, false);
		        		Okno okno = new Okno(system, false);
		        		okno.setVisible(true);
		        		
		        		Host host1 = new Host(system, "Host1");
		        		host1.addEth(new Eth(host1, "eth0", MAC.generateMac(system)));
		        		host1.setGateway(new IP("192.168.1.1"));
		        		host1.setDns(new IP("192.168.1.0"));
		        		host1.setDnsConfiguration(new Dns(null));
		        		
		        		Host host2 = new Host(system, "Host2");
		        		host2.addEth(new Eth(host2, "eth0", MAC.generateMac(system)));

		        		Host host3 = new Host(system, "Host3");
		        		host3.addEth(new Eth(host3, "eth0", MAC.generateMac(system)));
		        		host3.addEth(new Eth(host3, "eth1", MAC.generateMac(system)));

		        		Host host4 = new Host(system, "Host4");
		        		host4.addEth(new Eth(host4, "eth0", MAC.generateMac(system)));
		        		Host host5 = new Host(system, "Host5");
		        		host5.addEth(new Eth(host5, "eth0", MAC.generateMac(system)));
		        		//Host host6 = new Host(system, "Host6");
		        		//host6.addEth(new Eth(host6, "eth0", MAC.generateMac(system)));

		        		Network network1 = new Network(system, "Zmijozel");
		        		Network network2 = new Network(system, "Nebelv�r");
		        		
		        		system.addHost(host1);
		        		system.addHost(host2);
		        		system.addHost(host3);
		        		system.addHost(host4);
		        		system.addHost(host5);
		        		//system.addHost(host6);
		        		system.addNetwork(network1);
		        		system.addNetwork(network2);
		        		system.attach(host1.getEth("eth0"), network1);
		        		system.attach(host2.getEth("eth0"), network1);
		        		
		        		system.attach(host3.getEth("eth0"), network1);
		        		system.attach(host3.getEth("eth1"), network2);
		        		
		        		system.attach(host4.getEth("eth0"), network2);
		        		system.attach(host5.getEth("eth0"), network2);
		        		//system.attach(host6.getEth("eth0"), network2);
		        		
		        		//system.attach(host2.getEth("eth1"), network2);
		        		//system.attach(host3.getEth("eth0"), network2);
		        		//system.attach(host3.getEth("eth1"), network3);
		        		
		        		host1.getEth("eth0").setActive(true);
		        		host1.getEth("eth0").setIp(new IP("192.168.1.0"));
		        		host1.getEth("eth0").setMask(new IP("255.255.255.0"));
		        		
		        		host1.x = 25; host1.y = 50;
		        		host2.x = 150; host2.y = 50;
		        		host3.x = 275; host3.y = 50;
		        		network1.x = 100 ; network1.y = 150;
		        		network2.x = 200 ; network2.y = 150;		
		        		
		        		okno.onConfigurationChange();
		        		
		        	} catch (Exception e) {
						e.printStackTrace();
					}
		        }
		    });
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
