package net.ouska.networking.hint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Hint {

	protected String name;
	protected Map<String, Hint> next = new HashMap<String, Hint>();
	
	public Hint(String name) {
		this.name = name;
	}
	
	public void add(Hint hint) {
		next.put(hint.name, hint);
	}

	public Hint get(String name) {
		return next.get(name);
	}
	
	public List<Hint> next(String value) {
		List<Hint> hints = new ArrayList<Hint>();
		for (Hint hint : next.values()) {
			if (hint instanceof Param || hint.name.toLowerCase().startsWith(value.toLowerCase())) {
				hints.add(hint);
			}
		}
		return hints;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

}
